/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.type;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopXPEntryType
extends AbstractShopEntryType {
    public int xpCount;
    public ItemStack iconPath = Items.f_42612_.m_7968_();

    public ShopXPEntryType(int xpCount) {
        this.xpCount = xpCount;
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        int experience;
        long playerMoney = SDMShopR.getMoney(player);
        long needMoney = entry.entryPrice * (long)countBuy;
        player.f_36079_ = experience = ShopXPEntryType.getPlayerXP(player) + this.xpCount * countBuy;
        player.f_36078_ = ShopXPEntryType.getLevelForExperience(experience);
        int expForLevel = ShopXPEntryType.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
        SDMShopR.setMoney(player, playerMoney - needMoney);
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        int experience;
        player.f_36079_ = experience = ShopXPEntryType.getPlayerXP(player) - this.xpCount * countSell;
        player.f_36078_ = ShopXPEntryType.getLevelForExperience(experience);
        int expForLevel = ShopXPEntryType.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
        SDMShopR.addMoney(player, entry.entryPrice * (long)countSell);
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)ShopXPEntryType.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ShopXPEntryType.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ShopXPEntryType.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ShopXPEntryType.sum(level - 15, 37, 5);
        }
        return 1395 + ShopXPEntryType.sum(level - 30, 112, 9);
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    @Override
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        if (isSell) {
            return player.f_36079_ > countSell * this.xpCount;
        }
        long playerMoney = SDMShopR.getMoney(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (isSell) {
            if (player.f_36079_ == 0 || this.xpCount == 0) {
                return 0;
            }
            return player.f_36079_ / this.xpCount;
        }
        long playerMoney = SDMShopR.getMoney(player);
        if (entry.entryPrice == 0L) {
            return 127;
        }
        return (int)(playerMoney / entry.entryPrice);
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        ItemStack icon = this.iconPath.m_41777_();
        icon.m_41764_(this.shopEntry.entryCount);
        return ItemIcon.getItemIcon((ItemStack)icon);
    }

    @Override
    public Icon getCreativeIcon() {
        return ItemIcon.getItemIcon((Item)Items.f_42612_);
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
        group.addInt("xp", this.xpCount, v -> {
            this.xpCount = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopXPEntryType(this.xpCount);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.xptype");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("xp", this.xpCount);
        NBTUtils.putItemStack(nbt, "iconPath", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.xpCount = nbt.m_128451_("xp");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPath");
    }

    @Override
    public String getId() {
        return "xpType";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopXPEntryType(0);
        }
    }
}

